// GFX.SHADER
// 
// this file contains shaders that are used by the programmers to
// generate special effects not attached to specific geometry.  This
// also has 2D shaders such as fonts, etc.
//

// the REGION shader is generated by the map editor on temporary
// brushes around a selected area for testing parts of maps
textures/REGION
{
	surfaceparm nolightmap
}

// the background for the netgraph
lagometer
{
	nopicmip
	{
		map gfx/2d/lag.tga
	}
}

// blinked on top of lagometer when connection is interrupted
disconnected
{
	nopicmip
	{
		map gfx/2d/net.tga
	}
}

white
{
	{
		map *white
		blendfunc	GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}


console
{
	nopicmip
	nocompress

	{
		map ui/assets/SMOKE-16bit.tga
		rgbGen const ( 0.3 0.3 0.3 )
		blendfunc GL_ONE GL_ZERO
		tcmod scale 1.5 .75
		tcmod scroll 0.025 .05
	}
	{
		map ui/assets/SMOKE-16bit.tga
		blendfunc GL_ONE GL_ONE
		rgbGen const ( 0.2 0.2 0.2 )
		tcmod scale .5 .25
		tcmod scroll 0 .05 
	}
}

console2
{
	nopicmip
	nocompress
	{
		blendfunc blend
		map ui/assets/wolficonback4.tga	// the bg logo that goes over the console and under the text
	}
}




menuback
{

	{
		map textures/sfx/flag01.tga
			blendFunc blend
		//	blendFunc GL_ONE GL_ONE
		//	tcMod turb 0 .1 0 .9
			tcmod scale 1 1
		//	tcMod scroll .02  0.7
			
	} 
       
}

menuback2
{
	nopicmip
	{
		//map textures/sfx/protoflame.tga
		 map textures/sfx/specular3b.tga
			blendFunc GL_ONE GL_ZERO
			tcMod turb 0 .1 0 .2
			tcMod scale .4 .4
			tcmod scroll -.05  -.2
	} 
	{
		map textures/sfx/proto_zzzdrk.tga
			blendFunc blend
			//blendFunc GL_ONE GL_ONE
			tcMod turb 0 .1 0 .9
			tcmod scale .2 .2
			tcMod scroll .02  0.7
	} 
       
}

levelShotDetail
// used to break up the blur on levelshots
{
	nopicmip
	{
		map textures/sfx/detail.tga
        blendFunc GL_DST_COLOR GL_SRC_COLOR
		rgbgen identity
	}
}

//
// special effects as seen on players
//
powerups/battleSuit
{
	deformVertexes wave 100 sin 1 0 0 0
	{
		map textures/effects/envmapgold2.tga
                //map textures/sfx/specular.tga
		tcGen environment
		tcMod turb 0 0.15 0 0.3
                tcmod rotate 333
                tcmod scroll .3 .3
		blendfunc GL_ONE GL_ONE
	}
}
powerups/battleWeapon
{
	deformVertexes wave 100 sin 0.5 0 0 0
	{
		map textures/effects/envmapgold2.tga
                //map textures/sfx/specular.tga
		tcGen environment
		tcMod turb 0 0.15 0 0.3
                tcmod rotate 333
                tcmod scroll .3 .3
		blendfunc GL_ONE GL_ONE
	}
}

powerups/invisibility
{
	{
		map textures/effects/invismap.tga
                //map textures/effects/tinfx4.tga
		blendfunc GL_ONE GL_ONE
		tcMod turb 0 0.15 0 0.25
		tcGen environment
	}
}
powerups/quad
{
	deformVertexes wave 100 sin 3 0 0 0
	{
		map textures/effects/quadmap2.tga
		blendfunc GL_ONE GL_ONE
		tcGen environment
                tcmod rotate 30
		//tcMod turb 0 0.2 0 .2
                tcmod scroll 1 .1
	}
}
powerups/quadWeapon
{
	deformVertexes wave 100 sin 0.5 0 0 0
	{
		map textures/effects/quadmap2.tga
		blendfunc GL_ONE GL_ONE
		tcGen environment
                tcmod rotate 30
		//tcMod turb 0 0.2 0 .2
                tcmod scroll 1 .1
	}
}
powerups/regen
{
	deformVertexes wave 100 sin 3 0 0 0
	{
		map textures/effects/regenmap2.tga
		blendfunc GL_ONE GL_ONE
		tcGen environment
                tcmod rotate 30
		//tcMod turb 0 0.2 0 .2
                tcmod scroll 1 .1
	}
}
textures/test_autosprite
{
	deformVertexes autoSprite

	surfaceparm nomarks
	surfaceparm nolightmap
	cull none
	
	{
		animMap 10 textures/sfx/flame1.tga textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
	{
		animMap 10 textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga textures/sfx/flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}	


	{
		map textures/sfx/flameball.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6	
	}
}


textures/test_autosprite2
{
	deformVertexes autoSprite2

	surfaceparm nomarks
	surfaceparm nolightmap
	cull none	
	{
		animMap 10 textures/sfx/flame1.tga textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave inverseSawtooth 0 1 0 10
		
	}	
	{
		animMap 10 textures/sfx/flame2.tga textures/sfx/flame3.tga textures/sfx/flame4.tga textures/sfx/flame5.tga textures/sfx/flame6.tga textures/sfx/flame7.tga textures/sfx/flame8.tga textures/sfx/flame1.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sawtooth 0 1 0 10
	}	


	{
		map textures/sfx/flameball.tga
		blendFunc GL_ONE GL_ONE
		rgbGen wave sin .6 .2 0 .6	
	}
}

//=========================



//
// holdable item icons
//
icons/teleporter
{
	nopicmip
	{
		map icons/teleporter.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/medkit
{
	nopicmip
	{
		map icons/medkit.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/wine
{
	nopicmip
	{
		map icons/wine.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}
icons/wine2
{
	nopicmip
	{
		map icons/wine2.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}
icons/wine3
{
	nopicmip
	{
		map icons/wine3.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

//
// powerup icons
//
icons/quad
{
	nopicmip
	{
		map icons/quad.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/haste
{
	nopicmip
	{
		map icons/haste.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/invis
{
	nopicmip
	{
		map icons/invis.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/regen
{
	nopicmip
	{
		map icons/regen.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/flight
{
	nopicmip
	{
		map icons/flight.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}


//////////////////////////
//
// weapon icons
//
//////////////////////////

icons/noammo
{
	nopicmip
	nomipmaps
	{
		map icons/noammo.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_knife_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_knife_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_knife_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_knife_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_luger_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_luger_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_luger_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_luger_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_MP40_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_MP40_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_MP40_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_MP40_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_mauser_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_mauser_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_mauser_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_mauser_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_sp5_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_sp5_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_sp5_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_sp5_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_grenade_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_grenade_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_grenade_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_grenade_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_panzerfaust_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_panzerfaust_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_panzerfaust_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_panzerfaust_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_venom_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_venom_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_venom_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_venom_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_flamethrower_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_flamethrower_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_flamethrower_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_flamethrower_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_tesla_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_tesla_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_tesla_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_tesla_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_speargun_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_speargun_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_speargun_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_speargun_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_colt_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_colt_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_colt_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_colt_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_thompson_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_thompson_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_thompson_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_thompson_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_garand_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_garand_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_garand_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_garand_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_pineapple_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_pineapple_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_pineapple_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_pineapple_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_rocket_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_rocket_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_rocket_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_rocket_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_sniper_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_sniper_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_sniper_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_sniper_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_snooper_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_snooper_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_snooper_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_snooper_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_sten_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_sten_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_sten_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_sten_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_cross_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_cross_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_cross_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_cross_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

icons/iconw_dynamite_1
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_dynamite_1.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}

// (selected version)
icons/iconw_dynamite_1_select
{
	nopicmip
	nomipmaps
	{
		map icons/iconw_dynamite_1_select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}





//////////////////////////////


//
// ammo icons
//
icons/icona_machinegun
{
	nopicmip
	{
		map icons/icona_machinegun.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/icona_rocket
{
	nopicmip
	{
		map icons/icona_rocket.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}


icons/icona_grenade
{
	nopicmip
	{
		map icons/icona_grenade.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}


//
// armor icons
//
icons/iconr_shard
{
	nopicmip
	{
		map icons/iconr_shard.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

icons/iconr_yellow
{
	nopicmip
	{
		map icons/iconr_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

icons/iconr_red
{
	nopicmip
	{
		map icons/iconr_red.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

//
// health icons
//

//Wolf
icons/iconh_small
{
	nopicmip
	{
		map icons/iconh_small.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/iconh_med
{
	nopicmip
	{
		map icons/iconh_med.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/iconh_large
{
	nopicmip
	{
//		map icons/iconh_large.tga
		map icons/iconh_med.tga		// using this because large doesn't exist
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
icons/iconh_turkey
{
	nopicmip
	{
		map icons/iconh_turkey.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}


// Q3 legacy
icons/iconh_green
{
	nopicmip
	{
		map icons/iconh_green.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

icons/iconh_yellow
{
	nopicmip
	{
		map icons/iconh_yellow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

icons/iconh_red
{
	nopicmip
	{
		map icons/iconh_red.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

icons/iconh_mega
{
	nopicmip
	{
		map icons/iconh_mega.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}



//===================================================

gfx/2d/menuinfo
{
	nopicmip
	{
		map gfx/2d/menuinfo.tga
	}
}

gfx/2d/menuinfo2
{
	nopicmip
	{
		map gfx/2d/menuinfo2.tga
	}
}

gfx/2d/quit
{
	nopicmip
	nomipmaps
	{
		map gfx/2d/quit.tga
	}
}

gfx/2d/cursor
{
    nopicmip
	nomipmaps
    {
        map gfx/2d/cursor.tga
    }
}

//==========================================================================


sprites/balloon3
{
	{
		map sprites/balloon4.tga
		blendfunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

// this is an example of a crossfaded animation cycle
textures/animationTest
{
	qer_editorimage	textures/liquids/bloodwater1.tga
	{
		animMap 0.5 textures/liquids/bloodwater1.tga textures/liquids/pool.tga textures/liquids/slime7.tga
	}	
	{
		animMap 0.5 textures/liquids/pool.tga textures/liquids/slime7.tga textures/liquids/bloodwater1.tga
		blendFunc	GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen	wave sawtooth 0 1 0 0.5
	}	
	{
		map $lightmap
		blendFunc GL_DST_COLOR GL_ZERO
	}
}


spotLight
{
	nocompress
	polygonOffset
	{
		clampmap sprites/spotlight.tga
		blendfunc	GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}




lightBeam
{
	nocompress
	sort nearest
	cull none
	{
		map textures/sfx/white_grad.tga
//		blendfunc GL_ONE GL_ZERO
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		blendfunc	GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}



//lightBeam
//{
//	nocompress
//	sort nearest
//	cull none
//	{
//		map *white
//		blendfunc	GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbgen vertex
//	}
//}





teleportEffect
{
	cull none
	{
		map gfx/misc/teleportEffect2.tga
                blendFunc GL_ONE GL_ONE
		rgbGen entity
		tcMod scale 1 4
		tcMod scroll 0 2
	}
}

dlightshader 	// this one is the 'default' dlight shader blob
{
	{
		map $dlight
		blendfunc GL_DST_COLOR GL_ONE
	}
}

negdlightshader
{
	{
		map $dlight
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
	}
}


// markShadow is the very cheap blurry blob underneat the player
markShadow
{
	nofog
	polygonOffset
	{
		map sprites/shadow_soft.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}	
}

markShadowFoot
{
	nofog
	polygonOffset
	{
		map sprites/shadow_foot.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}	
}
markShadowTorso
{
	nofog
	polygonOffset
	{
		map sprites/shadow_torso.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}	
}

// projectionShadow is used for cheap squashed model shadows
//projectionShadow
//{
//	polygonOffset
//	deformVertexes projectionShadow
//	{
//		map *white
//		blendFunc GL_ONE GL_ZERO
//		rgbGen wave square 0 0 0 0				// just solid black
//	}	
//}


// wake is the mark on water surfaces for paddling players
wake
{


	{
		clampmap sprites/splashalpha.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		blendfunc blend
		rgbGen vertex
		tcMod stretch sin 1 0.2 0 0.2 
//		alphaGen sin 0.5 0.3 0 0.2 
//		rgbGen wave sin .7 .07 .25 .5
		rgbGen wave sin 0.3 0.3 0 0.2
	}

//	{
//		clampmap sprites/splashalpha.tga
//		//		blendFunc GL_ONE GL_ONE
//		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen vertex
//		//		tcMod stretch sin .9 0.05 0 0.5
//		//		rgbGen wave sin .7 .3 .25 .5
//		tcMod stretch sin .9 0.03 0 0.5
//		rgbGen wave sin .7 .07 .25 .5
//	}	
}

// this version is for projectiles/etc entering/leaving water
wakeAnim
{
	{
		clampmap sprites/splashalpha.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
//		alphagen wave 0 1 0.5 1
		tcmod stretch sin 0 1 0 .25
	}	
}


// viewBloodBlend gives the blended directional cue when you get hit
viewBloodBlend1
{
	sort	nearest
	{
		map models/weaphits/blood201.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen vertex
	}
}
viewBloodBlend2
{
	sort	nearest
	{
		map models/weaphits/blood202.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen vertex
	}
}
viewBloodBlend3
{
	sort	nearest
	{
		map models/weaphits/blood203.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen vertex
	}
}
viewBloodBlend4
{
	sort	nearest
	{
		map models/weaphits/blood204.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen vertex
	}
}
viewBloodBlend5
{
	sort	nearest
	{
		map models/weaphits/blood205.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identityLighting
		alphaGen vertex
	}
}

waterBubble
{
	sort	underwater
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/bubble.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

bloodPool
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/blood_splat.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

smokePuff
{
	nofog
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/smokepuff.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

// Rafael
oilParticle
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/oil_PARTICLE.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

oilSlick
{
	polygonOffset
	entityMergable

	surfaceparm slick
	{
		map textures/decals/oil_slick.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
	{
		map textures/effects/wdfx_W.tga
		blendFunc GL_ONE_MINUS_DST_ALPHA GL_ONE 
		tcmod scale 2 2
		tcGen environment
	}

}

// Rafael - cannon
smokePuffdirty
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/smokepuff_d.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

// Rafael - black smoke
// prerotated texture for smoke
smokePuffblack1
{
//	cull none
//	entityMergable		// allow all the sprites to be merged together
//	{
//		map gfx/misc/smokepuff_b1.tga
//		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen		vertex
//		alphaGen	vertex
//	}

//	nofog
	cull none
	{
		map gfx/misc/smokepuff_b1.tga
//		blendFunc GL_ZERO GL_ONE_MINUS_SRC_ALPHA
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA	// (SA) I put it back for DM
		alphaGen vertex
	}

}

smokePuffblack2
{
//	cull none
//	entityMergable		// allow all the sprites to be merged together
//	{
//		map gfx/misc/smokepuff_b2.tga
//		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen		vertex
//		alphaGen	vertex
//	}

//	nofog
	cull none
	{
		map gfx/misc/smokepuff_b2.tga
//		blendFunc GL_ZERO GL_ONE_MINUS_SRC_ALPHA
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA	// (SA) I put it back for DM
		alphaGen vertex
	}

}

smokePuffblack3
{
//	cull none
//	entityMergable		// allow all the sprites to be merged together
//	{
//		map gfx/misc/smokepuff_b3.tga
//		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen		vertex
//		alphaGen	vertex
//	}

//	nofog
	cull none
	{
		map gfx/misc/smokepuff_b3.tga
//		blendFunc GL_ZERO GL_ONE_MINUS_SRC_ALPHA
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA	// (SA) I put it back for DM
		alphaGen vertex
	}

}

smokePuffblack4
{
//	cull none
//	entityMergable		// allow all the sprites to be merged together
//	{
//		map gfx/misc/smokepuff_b4.tga
//		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen		vertex
//		alphaGen	vertex
//	}

//	nofog
	cull none
	{
		map gfx/misc/smokepuff_b4.tga
//		blendFunc GL_ZERO GL_ONE_MINUS_SRC_ALPHA
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA	// (SA) I put it back for DM
		alphaGen vertex
	}

}

smokePuffblack5
{
//	cull none
//	entityMergable		// allow all the sprites to be merged together
//	{
//		map gfx/misc/smokepuff_b5.tga
//		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen		vertex
//		alphaGen	vertex
//	}
	
//	nofog
	cull none
	{
		map gfx/misc/smokepuff_b5.tga
//		blendFunc GL_ZERO GL_ONE_MINUS_SRC_ALPHA
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA	// (SA) I put it back for DM
		alphaGen vertex
	}

}
// done

smokePuffRagePro
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/smokepuffragepro.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

shotgunSmokePuff
{
	cull none
	{
		map gfx/misc/smokepuff2b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		alphaGen entity		
		rgbGen entity
	}
}
rlboom_1
{
	sort additive
	{
		map models/weaphits/rlboom/rlboom_1.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rlboom/rlboom_2.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rlboom_2
{
	sort additive
	{
		map models/weaphits/rlboom/rlboom_2.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rlboom/rlboom_3.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rlboom_3
{
	sort additive
	{
		map models/weaphits/rlboom/rlboom_3.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rlboom/rlboom_4.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rlboom_4
{
	sort additive
	{
		map models/weaphits/rlboom/rlboom_4.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rlboom/rlboom_5.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rlboom_5
{
	sort additive
	{
		map models/weaphits/rlboom/rlboom_5.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rlboom/rlboom_6.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rlboom_6
{
	sort additive
	{
		map models/weaphits/rlboom/rlboom_6.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rlboom/rlboom_7.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rlboom_7
{
	sort additive
	{
		map models/weaphits/rlboom/rlboom_7.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rlboom/rlboom_8.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rlboom_8
{
	sort additive
	{
		map models/weaphits/rlboom/rlboom_8.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
glboom_1
{
	sort additive
	{
		map models/weaphits/glboom/glboom_1.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/glboom/glboom_2.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
glboom_2
{
	sort additive
	{
		map models/weaphits/glboom/glboom_2.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/glboom/glboom_3.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
glboom_3
{
	sort additive
	{
		map models/weaphits/glboom/glboom_3.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rgboom_1
{
	sort additive
	{
		map models/weaphits/rgboom/rgboom_1.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rgboom/rgboom_2.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rgboom_2
{
	sort additive
	{
		map models/weaphits/rgboom/rgboom_2.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/rgboom/rgboom_3.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
rgboom_3
{
	sort additive
	{
		map models/weaphits/rgboom/rgboom_3.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
bfgboom_1
{
	sort additive
	{
		map models/weaphits/bfgboom/bfgboom_1.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/bfgboom/bfgboom_2.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
bfgboom_2
{
	sort additive
	{
		map models/weaphits/bfgboom/bfgboom_2.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	{
		map models/weaphits/bfgboom/bfgboom_3.tga
		rgbGen entity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
bfgboom_3
{
	sort additive
	{
		map models/weaphits/bfgboom/bfgboom_3.tga
		rgbGen oneminusentity
		blendfunc GL_ONE GL_ONE
	}
	cull disable
}
flare
{
	cull none
	{
		map gfx/misc/flare.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
	}
}


flareShader
{
	nofog		// don't fog
	nopicmip	// use hi-res tex all the time
	cull none
	{

	///////////
	//
	//	IF YOU CHANGE SHIT, COMMENT WHAT THE xxxx YOU ARE DOING!!!!!!!!
	//
	//////////

//		map gfx/misc/flare.tga
//		map gfx/misc/flare2.tga
//		map gfx/misc/flare3.tga
		map gfx/misc/flare5.tga	// new one made by SA
//		map gfx/misc/flare5b.tga	// same, just made for additive blend (nofog required)

//		blendFunc GL_ONE GL_ONE
///		blendFunc blend
//		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
		blendFunc GL_SRC_ALPHA GL_ONE
		rgbGen vertex
	}
}
sun
{
	nofog
	nocompress
	cull none
	{
		map gfx/misc/sun.tga
//		blendFunc GL_ONE_MINUS_SRC_ALPHA GL_SRC_ALPHA
//		blendFunc GL_ONE GL_ONE
		blendFunc blend
		rgbGen vertex
	}
}
railDisc
{
	nofog
	sort nearest
	cull none
        deformVertexes wave 100 sin 0 3 0 2.4
	{
		clampmap gfx/misc/raildisc_mono2.tga 
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
                 tcMod rotate -30
	}
}

railCore
{
	sort nearest
	cull none
	{
		map gfx/misc/railcorethin_mono.tga
		blendFunc GL_ONE GL_ONE
		rgbGen vertex
		tcMod scroll -1 0
	}
}

//lightningBolt
//{
//	cull none
//	{
//		map gfx/misc/lightning3.tga
//		blendFunc GL_ONE GL_ONE
//                rgbgen wave sin 1 5.1 0 7.1
//                 tcmod scale  2 1
//		tcMod scroll -2.3 0
//	}
//    {
//		map gfx/misc/lightning3.tga
//		blendFunc GL_ONE GL_ONE
//                rgbgen wave sin 1 8.3 0 8.1
//                tcmod scale  -1.3 -1
//		tcMod scroll 1.2 0
//	}
//}

// shader used on the occasional machinegun bullet tracers
gfx/misc/tracer
{
	cull none
	{
		map	gfx/misc/tracer2.tga
		blendFunc GL_ONE GL_ONE
	}
}

gfx/misc/reticle
{
	nopicmip
	nomipmaps
	{
		map gfx/misc/reticle_eq.tga
		blendfunc filter
	}
}

gfx/misc/reticlesimple
{
	nopicmip
	nomipmaps
	{
//		map gfx/misc/reticlesimple.tga
//		map gfx/misc/reticle_eq.tga
//		map gfx/misc/reticle_256.tga
		clampmap gfx/misc/reticle_256.tga
		blendfunc filter
	}
}

gfx/misc/reticlesimple_quarter
{
	nopicmip
	nomipmaps
	{
		clampmap gfx/misc/reticle_q.tga
		blendfunc filter
	}
}

gfx/misc/snooper
{
	nopicmip
	nomipmaps
	{

//		map gfx/misc/snooper.tga
//		blendfunc filter


//		map gfx/misc/reticle_green.tga
///		blendfunc GL_ONE GL_ONE
//		blendfunc GL_ONE_MINUS_DST_COLOR GL_ONE_MINUS_SRC_COLOR

		map gfx/misc/reticle_eq.tga
		blendfunc GL_ONE_MINUS_DST_COLOR GL_ONE_MINUS_SRC_COLOR

	}
}




gfx/misc/snoopersimple_oldnotused
{
	nopicmip
	nomipmaps
	{
		map gfx/misc/snoopersimple.tga
		blendfunc filter
	}
}


// SA
// pretty temporary effect for snooper
// to show that the weapon will have an effect

gfx/misc/snoopersimple
{
	nopicmip
	nomipmaps
	{
//		map gfx/misc/reticle_eq.tga
		map gfx/misc/reticle_snoopblend.tga
		blendfunc GL_ONE_MINUS_DST_COLOR GL_ONE_MINUS_SRC_COLOR

//		blendfunc GL_DST_COLOR GL_ONE_MINUS_SRC_COLOR
//		blendfunc GL_ONE_MINUS_DST_COLOR GL_SRC_COLOR
//		blendfunc GL_DST_COLOR GL_SRC_COLOR
	}

	{	
		map textures/sfx/screen02.tga
		blendFunc add
		tcMod scroll 7.1  0.2
		tcmod scale .8 1
		rgbgen wave square .75 .05 0 5
	}

	{
//		map gfx/misc/reticle_eq.tga
		map gfx/misc/reticle_256.tga
		blendfunc filter
		rgbgen vertex
	}

}


gfx/misc/binocsimple
{
	nopicmip
	nomipmaps
	{
//		map gfx/misc/binocsimple.tga
		clampmap gfx/misc/binocsimple.tga
		blendfunc filter
	}
}

gfx/misc/binocsimple_quarter
{
	nopicmip
	nomipmaps
	{
//		map gfx/misc/binocsimple_q.tga
		clampmap gfx/misc/binocsimple_q.tga
		blendfunc filter
	}
}


//
// wall marks
// use blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR so that
// their "contribution" can be damped down in fog volumes
// with distance
bloodMark
{
	polygonOffset
	{
		map models/weaphits/blood201.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		// rgbGen identityLighting
		rgbGen	 vertex
		alphaGen vertex
	}
}

bloodTrail
{
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/blood_dot4.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

gfx/damage/bullet_mrk
{
	polygonOffset
	{
		map gfx/damage/bullet_mrk.tga
//		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
//		rgbGen exactVertex
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}
gfx/damage/burn_med_mrk
{
	polygonOffset
	{
		map gfx/damage/burn_med_mrk.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}
gfx/damage/hole_lg_mrk
{
	polygonOffset
	{
		map gfx/damage/hole_lg_mrk.tga
		blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR
		rgbGen exactVertex
	}
}
gfx/damage/plasma_mrk
{
	polygonOffset
	{
		map gfx/damage/plasma_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/damage/metal_mrk
{
	polygonOffset
	{
		map gfx/damage/metal_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/damage/wood_mrk
{
	polygonOffset
	{
		map gfx/damage/wood_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/damage/ceramic_mrk
{
	polygonOffset
	{
		map gfx/damage/ceramic_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}

gfx/damage/glass_mrk
{
	polygonOffset
	{
		map gfx/damage/glass_mrk.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
		alphaGen vertex
	}
}


//===============================================================


// the main console background image
gfx/2d/conback
{
	nopicmip
	nomipmaps
	{
		map gfx/2d/conback.tga
	}
}

gfx/2d/crosshair
{
	nopicmip
	{
		map gfx/2d/crosshairj.tga
               
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
                
                rgbGen identity
	}
        

}

gfx/2d/crosshairb
{
	nopicmip
	{
		map gfx/2d/crosshairb.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}
}

gfx/2d/crosshairc
{
	nopicmip
	{
		map gfx/2d/crosshairc.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}
}

gfx/2d/crosshaird
{
	nopicmip
	{
		map gfx/2d/crosshaird.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}
}

gfx/2d/crosshaire
{
	nopicmip
	{
		map gfx/2d/crosshaire.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}
}

gfx/2d/crosshairf
{
	nopicmip
	{
		map gfx/2d/crosshairf.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}
}

gfx/2d/crosshairg
{
	nopicmip
	{
		map gfx/2d/crosshairg.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}
}

gfx/2d/crosshairh
{
	nopicmip
	{
		map gfx/2d/crosshairh.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}
}

gfx/2d/crosshairi
{
	nopicmip
	{
		map gfx/2d/crosshairi.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}

}
gfx/2d/crosshairj
{
	nopicmip
	{
		map gfx/2d/crosshairj.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
//		rgbGen identity
		rgbGen vertex
	}
}



gfx/2d/hudchars
{
	nopicmip
	nomipmaps
	{
		map gfx/2d/hudchars.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbgen vertex
	}
}





gfx/2d/menu/bigchars
{
	nopicmip
	nomipmaps
	{
		map gfx/2d/bigchars.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}
gfx/2d/bigchars
{
	nopicmip
	nomipmaps
	{
		map gfx/2d/bigchars.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen vertex
	}
}
gfx/2d/select
{
	nomipmaps
	nopicmip
	{
		map gfx/2d/select.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen identity
		rgbGen vertex
	}
}


gfx/2d/assault1d
{
	nopicmip
	{
		map gfx/2d/assault1d.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/armor1h
{
	nopicmip
	{
		map gfx/2d/armor1h.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/health
{
	nopicmip
	{
		map gfx/2d/health.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/blank
{
	nopicmip
	{
		map gfx/2d/blank.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/zero_32b
{
	nopicmip
	{
		map gfx/2d/numbers/zero_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/one_32b
{
	nopicmip
	{
		map gfx/2d/numbers/one_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/two_32b
{
	nopicmip
	{
		map gfx/2d/numbers/two_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/three_32b
{
	nopicmip
	{
		map gfx/2d/numbers/three_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/four_32b
{
	nopicmip
	{
		map gfx/2d/numbers/four_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/five_32b
{
	nopicmip
	{
		map gfx/2d/numbers/five_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/six_32b
{
	nopicmip
	{
		map gfx/2d/numbers/six_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/seven_32b
{
	nopicmip
	{
		map gfx/2d/numbers/seven_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/eight_32b
{
	nopicmip
	{
		map gfx/2d/numbers/eight_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/nine_32b
{
	nopicmip
	{
		map gfx/2d/numbers/nine_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}
gfx/2d/numbers/minus_32b
{
	nopicmip
	{
		map gfx/2d/numbers/minus_32b.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
	}
}

bloodExplosion		// spurt of blood at point of impact
{
	cull disable
	{
		animmap 5 models/weaphits/blood201.tga models/weaphits/blood202.tga models/weaphits/blood203.tga models/weaphits/blood204.tga models/weaphits/blood205.tga
		blendfunc blend
	}
}

// Rafael
snowPuff
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/snow.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

snow_tri
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map gfx/misc/snow_tri.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

bloodani1
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/blood_ani/blood_01.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

bloodani2
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/blood_ani/blood_02.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

bloodani3
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/blood_ani/blood_03.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

bloodani4
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/blood_ani/blood_04.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

bloodani5
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/blood_ani/blood_05.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}

bloodani6
{
	cull none
	entityMergable		// allow all the sprites to be merged together
	{
		map sprites/blood_ani/blood_06.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen		vertex
		alphaGen	vertex
	}
}


// Rafael
// wall marks
// use blendFunc GL_ZERO GL_ONE_MINUS_SRC_COLOR so that
// their "contribution" can be damped down in fog volumes
// with distance
wolfbloodMark
{
	polygonOffset
	{
		map models/weaphits/bloodsplat.tga
		blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
		rgbGen	 vertex
		alphaGen vertex
	}
}




